# Creating Windhawk Task scheduler entry

## Start - Modify your values here - ##

[string]$taskName = "Starting Windhawk at User logon"
[string]$exePath = "C:\Users\Public\.Windhawk\windhawk.exe"
[string]$arguments = "-tray-only"
[string]$startIn = Split-Path $exePath -Parent

## End - Modify your values here - ##

[string]$user = $env:userdomain + "\" + $env:username

# Define the action
$action = New-ScheduledTaskAction -Execute $exePath -Argument $arguments -WorkingDirectory $startIn

# Define the trigger (at logon)
$trigger = New-ScheduledTaskTrigger -AtLogOn -User $user

# Define the principal (current user, no elevated privileges)
$principal = New-ScheduledTaskPrincipal -UserId "$env:USERNAME" -LogonType Interactive -RunLevel Limited

# Define settings (no time limit, allow on battery)
$settings = New-ScheduledTaskSettingsSet `
    -ExecutionTimeLimit (New-TimeSpan -Seconds 0) `
    -DisallowStartIfOnBatteries:$false `
    -StopIfGoingOnBatteries:$false

# Register the task
Register-ScheduledTask -TaskName $taskName -Action $action -Trigger $trigger -Principal $principal -Settings $settings

## End of script
