# Windows Recovery Partition loeschen und neu erstellen

## Alle Befehle in einer mit Adminrechten versehenen PowerShell-Sitzung ausfuehren

# Informationen ueber den Zustand des Windows Recovery Environments (Windows RE)
reagentc /info

# Deaktivieren von Windows RE
reagentc /disable

# Informationen ueber Disk und Partition liefern die folgenden Befehle
Get-Disk

Get-Partition

# Im Beispiel handelt es sich um Disk 0 und Partition 4, diese kann wie folgt mit PowerShell geloescht werden
Remove-Partition -DiskNumber 0 -PartitionNumber 4 -PassThru -Confirm:$false

# Ermitteln der maximal zu erweitertenden Kapazitaet (MaxSize - 524MB)
[String]$DriveLetter = 'C'
[Int64]$WinREsize = 524mb
[Int64]$NewSize = ((Get-PartitionSupportedSize -DriveLetter $DriveLetter).SizeMax - $WinREsize)

# Kapazitaet nach der Erweiterung
$NewSize

# Erweitern von Laufwerk C auf $NewSize
Resize-Partition -DriveLetter $DriveLetter -Size $NewSize

# Anlegen der Windows RE Parition und formatieren mit NTFS
[string]$FileSystem = 'NTFS'
[string]$FileSystemLabel = 'Windows RE'
New-Partition -DiskNumber 0 -UseMaximumSize | Format-Volume -FileSystem $FileSystem -NewFileSystemLabel $FileSystemLabel

# Setzen der ID=de94bba4-06d1-4d40-a16a-bfd50179d6ac
[string]$ID = '{de94bba4-06d1-4d40-a16a-bfd50179d6ac}'
Set-Partition -DiskNumber 0 -PartitionNumber 4 -GptType $ID

# Aendern des GPT Attributes auf 0x8000000000000001, das einzige Mal wo uns PowerShell im Stich laesst ;-)
$null = @"
    select disk 0
    select partition 4
    gpt attributes=0x8000000000000001
    exit
"@ | diskpart.exe

# Pruefen ob die Winre.wim vorhanden ist
Get-ChildItem -Path "$env:windir\System32\Recovery" -Attributes h

# Wechsel in das Recovery-Verzeichnis
Set-Location -Path "$env:windir\System32\Recovery"

# Aktivieren von Windows RE
reagentc /enable


# Emergency-Update 2025-10-08-01, REAGENTC.EXE: The Windows RE Image was not found.

## Mounten einer Windows Server oder Windows Client ISO auf dem System (Doppelklick mit dem Windows Explorer ...)
## Auf meinem System wurde die ISO-Datei unter dem Laufwerksbuchstaben g bereitgestellt
## Laufwerk d sollte dann zum mounten der install.wim verwendet werden - also merken, g und d ;-)

# Erstellen eines Verzeichnisses um die install.wim zu mounten
[string]$wimDir = 'd:\wim'
New-Item -Path $wimDir -Type Directory

# Mount der install.wim Datei nach d:\wim / $wimDir mit "/readonly"
dism /mount-wim /mountdir:$wimDir /wimfile:\sources\install.wim /index:1 /readonly

# Wechsel in das Recovery-Verzeichnis der gemounteten install.wim
Set-Location -Path 'D:\wim\Windows\System32\Recovery\'

# Kopieren der Winre.wim nach c:\windows\system32\recovery
Copy-Item -Path .\Winre.wim -Destination "$env:windir\System32\Recovery"

# Wechsel nach C:\Windows\System32\Recovery
Set-Location -Path "$env:windir\System32\Recovery\"

# Aktivieren von Windows RE - muss im Verzeichnis 'C:\Windows\System32\Recovery' ausgeführt werden
reagentc /enable

# Unmount des install.wim Images
dism /unmount-wim /mountdir:$wimDir /discard

# So jetzt aber :-)
