# Import PowerShell Module WebAdministration
Import-Module WebAdministration

# Set WsusPool as variable
[string]$Path = "IIS:\AppPools\WsusPool"

# Queue Length	2000 (up from default of 1000)
[int]$queueLength = 2000
[string]$Name = "queueLength"
# Set-ItemProperty -Path IIS:\AppPools\WsusPool -Name queueLength $queueLength
Set-ItemProperty -Path ($Path) -Name $Name $queueLength
# Get-ItemProperty -Path ($Path) | Select-Object -Property $Name

# Idle Time-out (minutes)	0 (down from the default of 20)
[string]$Name = "processModel.idleTimeout"
[int]$Minutes = 0
Set-ItemProperty -Path ($Path) -Name $Name -Value ([TimeSpan]::FromMinutes($Minutes))

# Ping Enabled	False (from default of True)
[string]$Name = "processModel.pingingEnabled"
[bool]$pingingEnabled = $False
Set-ItemProperty -Path ($Path) -Name $Name -Value $pingingEnabled

# Private Memory Limit (KB)	0 (unlimited, up from the default of 1,843,200 KB)
[string]$Name = "recycling.periodicRestart.privateMemory"
[int]$privateMemory = 0
Set-ItemProperty -Path ($Path) -Name $Name -Value $privateMemory

# Regular Time Interval (minutes)	0 (to prevent a recycle, and modified from the default of 1740)
[string]$Name = "recycling.periodicRestart.time"
[int]$time = 0
Set-ItemProperty -Path ($Path) -Name $Name -Value ([TimeSpan]::FromMinutes($time))

# Restart of WsusPool
Restart-WebAppPool -Name "WsusPool" -Verbose


