#Requires -RunAsAdministrator

<#
    Version Information:
        v0.01, initial Script
        v0.02, fixed problem with piping the path of the shell extension. changed to Remove-Item -LiteralPath $RegPath -Force
#>

# Remove DxO PureRaw 4 from Windows startup and also remove the icon from the system tray
Write-Output "Remove DxO PureRaw 4 from Windows Startup and also remove the Icon from the system tray"


# Terminating the PureRaw process
Write-Output " Stopping the PureRawv4 process"
[string]$ProcessName = 'PureRawv4'
Get-Process | Where-Object -Property Name -EQ $ProcessName | Stop-Process -Force


# Windows Startup
Write-Output " Working on Windows Startup"
[string]$FilePath = "$env:ProgramData\Microsoft\Windows\Start Menu\Programs\Startup\DxO PureRAW 4.lnk"
Get-ChildItem -Path $FilePath | Remove-Item -Force


# Windows Explorer Shell Extension
Write-Output " Working on Windows Shell Extension"
[string]$RegPath = 'HKLM:\SOFTWARE\Classes\*\shellex\ContextMenuHandlers\{7E6AAE52-1F6D-4BCA-A844-CD8273F428CE}'
Remove-Item -LiteralPath $RegPath -Force


Write-Output "Script finished, please reboot your system ..."
