# Configure Synology L2TP based VPN on Windows

[string]$Name = 'VPN Synology'

[string]$ServerAddress = 'your.dydns-address.tld'   # Put your DyDns-address here, this is your VPN endpoint
[string]$User = 'test-vpn'                          # User allowed to make VPN connections (can be configured as local or domain user), for both users only the name is required
[string]$TunnelType = 'L2TP'                        # L2TP/IPsec with pre-shared key 
[string]$L2tpPsk = '5817e311ce58dad39fd6769f2'      # your pre-shared key (also to be uses in your Synology VPN Server configuration)
[string]$AuthenticationMethod = 'MSChapv2'          # Auth required for L2TP

# Note, to generate a key in PowerShell (to be used on the Synology VPN server and for this script, use the following command inside a PowerShell session)
## Powershell -Command "[Convert]::ToBase64String((1..48|%{[byte](Get-Random -Max 256)}))"

# Header
Write-Output "Setup of VPN Connection to $Name"

# Testing DynDns-address
If (Resolve-DnsName -Name $ServerAddress) {
    # Create VPN Connection, only of DynDns can be successfull resolved
    Add-VpnConnection -Name $Name -ServerAddress $ServerAddress -TunnelType $TunnelType -L2tpPsk $L2tpPsk -AuthenticationMethod $AuthenticationMethod -Force
} Else {
    Write-Output " VPN endpoint $ServerAddress isn't available"
}

# End of this script

