# Configure VPN settings on your Windows computer in the registry

#Requires -Version 5
#Requires -RunAsAdministrator   # Must be executed with admin (elevated) privileges

[string]$Path = 'HKLM:\SYSTEM\CurrentControlSet\Services\PolicyAgent'
[string]$Name = 'AssumeUDPEncapsulationContextOnSendRule'
[string]$Type = 'DWORD'
[Int16]$Value = 2       # Client and NAS behind a NAT-Connection
# [Int16]$Value = 1     # Only NAS behind a NAT-Connection
# [Int16]$Value = 0     # Neither client nor NAS behind a NAT-Connection

# Adding Registry-Key derived from https://learn.microsoft.com/en-us/troubleshoot/windows-server/networking/configure-l2tp-ipsec-server-behind-nat-t-device
New-ItemProperty -Path $Path -Name $Name -Value $Value -PropertyType $Type -Force -Verbose


<# - Start fix for Error 787

# If L2TP fails with error 787
[string]$Path = 'HKLM:\SYSTEM\CurrentControlSet\Services\RasMan\Parameters'
[string]$Name = 'ProhibitIpSec'
[string]$Type = 'DWORD'
[Int16]$Value = 1       # Disable IPsec for VPN  

# Adding Registry-Key derived from https://learn.microsoft.com/en-us/troubleshoot/windows-server/networking/l2tp-vpn-fails-with-error-787
New-ItemProperty -Path $Path -Name $Name -Value $Value -PropertyType $Type -Force -Verbose

End fix for Error 787 - #>
 
# End of this script