<#
	Disclaimer

	The author isn't responsible or gives any warranties in cases of data loss or unwanted modifications! 

#>

<#	           
    .SYNOPSIS 
        Fix Windows Server Essentials Launchpad for Windows Version 1903 get the Windows Server Essentials Launchpad back working on an Upgraded Windows 10 1903 client.

    .DESCRIPTION 
        Adds missing Registry Keys to enable the Windows Server Essentials Launchpad again.
        
    .NOTES 
        File Name : Fix-WSELaunchpad-1903.ps1
        Authors   : Bernd Pfann (sbsland@outlook.de)
        Version   : 0.02.0 (09/12/2019)

    .LINK 
        none

    .EXAMPLE 
        Fix-WSELaunchpad-1903.ps1
		
		Adds missing registry to bring Windows Server Essential Services back on the client.
 
#> 

<#

    History
        0.01, initial version
        0.02, now supporting Versions 1903 and higher (changed comparison from -eq to -le)
        0.03, correted minor typos
        0.04, corrected version and build numbers
        0.05, Minor update for Windows 11
        
#>


# Parameters

# Setting Debug Level
Set-PSDebug -Trace 0

# Variables
[string]$Log = $env:temp + "\Fix-WSELaunchpad-1903.log"
[string]$Msg = "Fixing Windows Server Essentials Launchpad on Windows 10 version 1903 and later (including Windows 11), Copyright sbsland.me 2021"
[int]$minVersion = 1903
[int]$Build = ([System.Environment]::OSVersion.Version).Build
[int]$Major = ([System.Environment]::OSVersion.Version).Major
[int]$Version = (Get-ItemProperty 'HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion' -Name ReleaseID).ReleaseId

# Start of output logging and error handling
$ErrorActionPreference = "Continue"
Start-Transcript -Path $Log | Out-Null

# Header
Write-Output `n$msg`n 

# Main Program

If ($minVersion -le (Get-ItemProperty 'HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion' -Name ReleaseID -ErrorAction Stop).ReleaseID) {

    Write-Output "  Windows is running on version $Version, the minimum version is $minVersion ..."
    Write-Output "   Current Windows major version is $Major"
    Write-Output "   Current Windows build number is $Build"
	Write-Output "   Adding missing Registry Keys ..."
	reg import .\ServiceProviderRegistry.reg
	reg import .\WseClientMgmtSvc.reg
	reg import .\WseClientMonitorSvc.reg
	reg import .\WseHealthSvc.reg
	reg import .\WseNtfSvc.reg

	Write-Output "  Registry Keys have been added, please reboot your Computer."
} Else {
    Write-Output "  Windows isn't running on Version $minVersion or later, no action is required."
    Write-Output "   The current Windows 10 version is $Version with build $Build."
}

Write-Output "  Please reboot your system."
Write-Output " Script finished!"
Stop-Transcript | Out-Null

# Resetting Debug Level
Set-PSDebug -Trace 0 
