
#Requires -RunAsAdministrator

# Variabeln
[array]$Services = @("wuauserv", "cryptSvc", "bits", "msiserver")
[string]$Output = ""
[string]$SoftwareDistribution = $ENV:WINDIR + '\SoftwareDistribution'
[string]$CatRoot2 = $ENV:WINDIR + '\System32\CatRoot2'
[string]$SoftwareDistributionDatabasePath = $SoftwareDistribution + '\DataStore\DataStore.edb'

# Pfad zu Sysinternals handle.exe, https://docs.microsoft.com/en-us/sysinternals/downloads/handle
[string]$Handle = 'C:\Program Files (x86)\Windows Sysinternals Tools\handle.exe'

# Stop aller Dienste die im Status "Running" sind
$Services | ForEach-Object {
	If (Get-Service -Name $_ | Where-Object {$_.Status -EQ 'Running'}) {
		Stop-Service -Name $_ -Force -Verbose
	}
}

# Prüfen ob noch ein Handle im Verzeichnis C:\Windows\SoftwareDistribution offen ist
$Output = ( & $Handle -Nobanner $SoftwareDistributionDatabasePath )

# Wird ein offenes handle gefunden, dann liefert handle.exe die PID dafür mit - über diese wird der Process terminiert
If ($Output | Select-String -Pattern "pid") {
	$Option = [System.StringSplitOptions]::RemoveEmptyEntries
	[array]$SplitOutput = $Output.Split(" ", $Option)	
	Stop-Process -Id $SplitOutput[2] -Force
}

# löschen der beiden Verzeichnisse
Remove-Item -Path $SoftwareDistribution -Force -Verbose -Recurse
Remove-Item -Path $CatRoot2 -Force -Verbose -Recurse

# Neustart des Computers
Restart-Computer -Confirm


